/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ras;

import com.ibm.ras.RASConsoleHandler;
import com.ibm.ras.RASIEvent;
import ibm.nways.jdm.SystemComponent;
import ibm.nways.ras.ConsoleFormatter;
import ibm.nways.ras.LogInterface;
import ibm.nways.ras.LogPrintStream;
import ibm.nways.ras.MessageFormatter;
import ibm.nways.ras.MessageLog;
import ibm.nways.ras.MultiFileHandler;
import ibm.nways.ras.RAS;
import ibm.nways.ras.RemoteHandler;
import ibm.nways.ras.TraceConsoleFormatter;
import ibm.nways.ras.TraceFormatter;
import ibm.nways.ras.TraceLog;
import java.io.File;
import java.io.PrintStream;
import java.rmi.RemoteException;
import netscape.security.PrivilegeManager;

public class LogService
extends SystemComponent
implements LogInterface,
Runnable {
    private static final String DEFAULT_LOG_FILE_PREFIX = "NwaysManager";
    private static final String DEFAULT_LOG_FILE_SIZE = "1048576";
    private static final String DEFAULT_LOG_FILE_NUM = "10";
    private static final String DEFAULT_LOG_DIRECTORY = "log";
    private static final String DEFAULT_MSG_FILENAME = "NwaysMessageCatalog.properties";
    private static final String PARM_LOG_FILE_SIZE = "logFileSize";
    private static final String PARM_LOG_FILE_NUM = "logFileNumber";
    private static final String PARM_LOG_FILE_PREFIX = "logFilePrefix";
    private static final String PARM_START_TRACING = "startTracing";
    private static final String PARM_START_LOGGING = "startLogging";
    private static final String PARM_LOG_TO_CONSOLE = "logToConsole";
    private int servicePort = 2099;
    private String serviceName = "Log Service";
    private static LogService singleton = null;
    private String logDirectory = "";
    private String remoteHostName = "";
    private int remoteHostPort;
    private boolean writeToConsole = true;
    private boolean isInitialized = false;
    private RASConsoleHandler serverconsole;
    private MultiFileHandler serverlogfile;
    private RemoteHandler serverremote;
    private ConsoleFormatter conformatter;
    private TraceConsoleFormatter tcnformatter;
    private MessageFormatter msgformatter;
    private TraceFormatter trcformatter;
    private String msgfilename = "NwaysMessageCatalog.properties";

    public LogService() throws RemoteException {
        singleton = this;
    }

    public void setBaseDirectory(String string) throws RemoteException {
        this.logDirectory = string;
    }

    public void setMaster(String string, int n) {
        this.remoteHostName = string;
        this.remoteHostPort = n;
        this.serverremote = new RemoteHandler();
        this.serverremote.setRASServer(this.remoteHostName);
    }

    public void start() {
        super.start();
    }

    public void run() {
        Object object;
        if (System.getProperty("java.vendor").indexOf("Netscape") >= 0) {
            PrivilegeManager.enablePrivilege((String)"UniversalPropertyWrite");
        }
        RAS.init();
        String string = SystemComponent.getComponentProperty(PARM_LOG_TO_CONSOLE, "no");
        this.writeToConsole = string.toLowerCase().equals("yes");
        string = SystemComponent.getComponentProperty(PARM_START_LOGGING, "yes");
        if (string.toLowerCase().equals("yes")) {
            RAS.gml(1, 1, 1).enable();
        } else {
            RAS.gml(1, 1, 1).disable();
        }
        string = SystemComponent.getComponentProperty(PARM_START_TRACING, "no");
        if (string.toLowerCase().equals("yes")) {
            RAS.gtl(1, 1, 1).enable();
        } else {
            RAS.gtl(1, 1, 1).disable();
        }
        if (this.remoteHostName.equals("")) {
            this.logDirectory = this.getComponentDirectory(DEFAULT_LOG_DIRECTORY);
            this.serverlogfile = new MultiFileHandler();
            this.serverlogfile.setBaseDirectory(this.logDirectory);
        }
        this.serverconsole = new RASConsoleHandler();
        if (this.remoteHostName.equals("")) {
            object = new File(this.logDirectory);
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            if (((File)object).isDirectory()) {
                ((File)object).delete();
                ((File)object).mkdir();
            }
            String string2 = SystemComponent.getComponentProperty(PARM_LOG_FILE_SIZE, DEFAULT_LOG_FILE_SIZE);
            this.serverlogfile.setMaxFileSize(Integer.parseInt(string2));
            String string3 = SystemComponent.getComponentProperty(PARM_LOG_FILE_NUM, DEFAULT_LOG_FILE_NUM);
            this.serverlogfile.setMaxFiles(Integer.parseInt(string3));
            String string4 = SystemComponent.getComponentProperty(PARM_LOG_FILE_PREFIX, DEFAULT_LOG_FILE_PREFIX);
            this.serverlogfile.setPrefix(string4);
            this.msgformatter = new MessageFormatter();
            this.trcformatter = new TraceFormatter();
            this.serverlogfile.addFormatter(this.msgformatter);
            this.serverlogfile.addFormatter(this.trcformatter);
        }
        if (this.remoteHostName.equals("")) {
            RAS.gml(1, 1, 1).addHandler(this.serverlogfile);
            RAS.gtl(1, 1, 1).addHandler(this.serverlogfile);
        } else {
            RAS.gml(1, 1, 1).addHandler(this.serverremote);
            RAS.gtl(1, 1, 1).addHandler(this.serverremote);
        }
        if (this.writeToConsole) {
            this.conformatter = new ConsoleFormatter();
            this.tcnformatter = new TraceConsoleFormatter();
            this.serverconsole.addFormatter(this.conformatter);
            this.serverconsole.addFormatter(this.tcnformatter);
            RAS.gml(1, 1, 1).addHandler(this.serverconsole);
            RAS.gtl(1, 1, 1).addHandler(this.serverconsole);
        }
        if (System.getProperty("java.vendor").indexOf("Netscape") < 0) {
            object = new LogPrintStream(RAS.gml(1, 1, 1));
            System.setOut((PrintStream)object);
            System.setErr((PrintStream)object);
            System.out.println(String.valueOf(this.serviceName) + " - changed System.out to log ...");
            System.out.println(String.valueOf(this.serviceName) + " - changed System.err to log ...");
        } else {
            System.out.println(String.valueOf(this.serviceName) + " - not rerouting System.out or System.err because it is illegal in Netscape ...");
            System.out.println(String.valueOf(this.serviceName) + " - certain messages will not appear in the Nways log");
        }
        if (this.remoteHostName.equals("")) {
            System.out.println(String.valueOf(this.serviceName) + " - base log directory: " + this.logDirectory);
        } else {
            System.out.println(String.valueOf(this.serviceName) + " - attaching to log server on: " + this.remoteHostName);
        }
        this.msgfilename = "ibm.nways.ras.NwaysMessageCatalog";
        System.out.println(String.valueOf(this.serviceName) + " - setting message catalog to " + this.msgfilename);
        RAS.gml(1, 1, 1).setMessageFile(this.msgfilename);
    }

    public static void registerManager() {
        if (singleton == null) {
            LogService.getManager();
        }
        singleton.register();
    }

    public void register() {
        super.register(this.serviceName, this.servicePort, 2);
    }

    public static LogService getManager() {
        try {
            if (singleton == null) {
                singleton = new LogService();
                singleton.run();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return singleton;
    }

    public static LogService getManager(String string, int n) {
        try {
            if (singleton == null) {
                singleton = new LogService();
                singleton.setMaster(string, n);
                singleton.run();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return singleton;
    }

    public MessageLog getMsgLog(int n) {
        return RAS.gml(n, 1, 1);
    }

    public MessageLog getMsgLog(int n, int n2) {
        return RAS.gml(n, n2, 1);
    }

    public MessageLog getMsgLog(int n, int n2, int n3) {
        return RAS.gml(n, n2, n3);
    }

    public TraceLog getTrcLog(int n) {
        return RAS.gtl(n, 1, 1);
    }

    public TraceLog getTrcLog(int n, int n2) {
        return RAS.gtl(n, n2, 1);
    }

    public TraceLog getTrcLog(int n, int n2, int n3) {
        return RAS.gtl(n, n2, n3);
    }

    public void test() {
        RAS.enableTrcLog(18);
        System.out.println(String.valueOf(this.serviceName) + " - executing test");
        if (RAS.isEnabled(18)) {
            RAS.enter(18, this, "test");
        }
        RAS.logWarning(18, this, "test", "TEST1");
        RAS.logWarning(18, this, "test", "TEST2", (Object)new Integer(12));
        RAS.logWarning(18, this, "test", "TEST2", (Object)new Integer(3));
        RAS.logInformation(18, this, "test", "TEST3");
        if (RAS.isEnabled(18)) {
            RAS.exit(18, this, "test");
        }
        try {
            Object object = null;
            object.getClass().getName();
        }
        catch (Exception exception) {
            RAS.logException(18, this, "test", exception);
        }
        System.out.println(String.valueOf(this.serviceName) + " - test complete");
    }

    public void process(RASIEvent rASIEvent) {
        this.serverlogfile.logEvent(rASIEvent);
    }

    public static void main(String[] stringArray) {
        try {
            LogService logService = new LogService();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-help") || stringArray[n].equals("-h")) {
                    System.out.println("Usage:");
                    System.out.println("    java.ibm.nways.ras.LogService");
                    System.out.println("Options:");
                    System.out.println("    -port    - port used to register with the RMI registry");
                    System.out.println("    -basedir - directory where log files will be written");
                    System.exit(0);
                } else if (stringArray[n].equals("-port")) {
                    logService.servicePort = Integer.parseInt(stringArray[n + 1]);
                    ++n;
                } else if (stringArray[n].equals("-basedir")) {
                    logService.setBaseDirectory(stringArray[n + 1]);
                    ++n;
                }
                ++n;
            }
            logService.run();
            logService.test();
            LogService.registerManager();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

